
# Show Messages
# Copyright 2005 by Alexander V. Christensen

"""
Intercept and display GanttPV's debugging messages.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050909 - first version

import sys

class MessageFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)

        self.SetTitle("Messages")
        self.SetSize((400, 350))

        sizer = wx.BoxSizer(wx.VERTICAL)
        self.display = wx.TextCtrl(self, style=(wx.TE_MULTILINE | wx.TE_READONLY))
        font = wx.Font(10, wx.MODERN, wx.NORMAL, wx.NORMAL)
        self.attr = wx.TextAttr(font=font)
        self.display.SetDefaultStyle(self.attr)
        sizer.Add(self.display, 1, wx.GROW | wx.ALL, 10)
        self.SetSizer(sizer)
        self.CentreOnScreen()

        self.text = ""

        # create menus
        menus = wx.MenuBar()
        id_clear = wx.NewId()
        id_reload = wx.NewId()

        fileMenu = wx.Menu()
        fileMenu.Append(id_clear, "Clear\tCtrl-K", "Clear messages")
        fileMenu.Append(id_reload, "Reload\tCtrl-R", "Reload messages")
        fileMenu.AppendSeparator()
        fileMenu.Append(wx.ID_CLOSE, "Close\tCtrl-W", "Close window")
        fileMenu.Append(wx.ID_EXIT, "Quit\tCtrl-Q", "Quit program")
        menus.Append(fileMenu, "File")

        helpMenu = wx.Menu()
        helpMenu.Append(wx.ID_ABOUT, "About GanttPV")
        helpMenu.Append(ID.HOME_PAGE, "GanttPV Home")
        helpMenu.Append(ID.HELP_PAGE, "Help Page", "URL of Help Text")
        helpMenu.Append(ID.FORUM, "Forum", "URL of Forum")
        menus.Append(helpMenu, "&Help")

        self.SetMenuBar(menus)
        self.Bind(wx.EVT_MENU, self.doClear, id=id_clear)
        self.Bind(wx.EVT_MENU, self.doReload, id=id_reload)
        self.Bind(wx.EVT_MENU, self.doClose, id=wx.ID_CLOSE)

    def doClear(self, event):
        self.text += self.display.GetValue()
        self.display.Clear()
        self.display.SetDefaultStyle(self.attr)

    def doReload(self, event):
        self.doClear(event)
        self.display.AppendText(self.text)
        self.text = ""

    def doClose(self, event):
        self.Close()

    def write(self, string):
        self.display.AppendText(string)


class OutputFork:
    def __init__(self, *targets):
        self.targets = dict.fromkeys(targets)
    def write(self, string):
        for t in self.targets.keys():
            try:
                t.write(string)
            except:
                del self.targets[t]


def ShowMessages():
    try:
        Data.message_window.Close()
    except AttributeError:
        pass
    frame = MessageFrame(None)
    ReportAids.RegisterSizePos(frame, "MessageWindow")
    sys.stdout = OutputFork(sys.__stdout__, frame)
    sys.stderr = OutputFork(sys.__stderr__, frame)
    frame.Show()
    Data.message_window = frame

ShowMessages()
